% Program: To evaluate the response for coeff.asm (bandpass.asm)
% File   : showfir.m
% Author : Danie Brynard ZS6AWK
% Update : 27/8/95
% Target : PC Matlab
% Notes  : Put the given FIR filter coefficients in file t.
%          please any feedback on bugs etc to my email address
% Email  : danie.brynard@pixie.co.za
clear
echo on
clc

%                     EVALUATE A GIVEN FIR FILTER RESPONSE
%
fs=8000; %sampling frequency

load t.  % read values from coeff.asm
B=t;
N=size(t);
N=N(1);
pause % Strike any key to continue.
format
clc
A(1)=1;
for i=2:N
A(N)=0;   %all-zero denominator because its a FIR filter
end
A=A';

n = 255;
hh = freqz(B,A,n); % compute complex frequency response, wait...
hy  = abs(hh);     % compute magnitude

pause % Strike any key for plot.
ff  = fs/(2*n) * (0:n-1);
plot(ff,hy), title('CW Filter Frequency Response up to fs/2'), ..
xlabel('Frequency (Hz)'), ylabel('Magnitude'), pause
% Show logarithmic scale..
plot(ff,10*log10(hy)), title('Log filter response'),..
xlabel('Frequency (Hz)'), ylabel('Magnitude (dB)'),  pause
% Zoom in ...
plot(ff(1:100),10*log10(hy(1:100))), title('Log filter response'),..
xlabel('Frequency (Hz)'), ylabel('Magnitude (dB)'),grid,pause
clc
% End of SHOWFIR.M
